# Base de datos
datos<-read.csv2("Tayrona.csv",row.names=1)

#------------------
# Libreras requeridas
library(ggplot2)
library(reshape2)
library(ggrepel)
library(vegan)
library(factoextra)
library(devtools)
install_github("vqv/ggbiplot")   # Escoger la Opcin 1. *Instalar solo una vez.
library(ggbiplot)
library(ggsci)
library(ggforce)
library(concaveman)


#----------------
# Ajuste de las bases de datos fisiqcoquimica (amb) y biolgica (tax.hel) 

str(datos)    # Estructura de la base de datos
datos$Epoca = as.factor (datos$Epoca)   # Convertir Epoca a factor
str(datos)    # Nueva estructura de la base de datos

# Variables ambientales
amb=log10(datos[,c(2:12)]+1)
amb

# Variables biolgicas linealizadas - Taxones con Hellinger
tax.hel=decostand(datos[,c(13:63)],"hellinger")
tax.hel




#------------------
# 1) PCA con paquete factoextra
pca <- prcomp(amb,scale.=T)
summary(pca)

# Contribucin eje 1
x11()
fviz_contrib(pca,choice="var",axes=1,
             title = "Contribuciones al Componente 1")

# Elipses por cada periodo climtico
fviz_pca_ind(pca, geom.ind = "point", 
             col.ind = datos$Epoca, # Colores por periodo
             palette = c("#00AFBB", "#E7B800", "#FC4E07"),
             addEllipses = TRUE, ellipse.type = "confidence",
             legend.title = "Grupos", title = "PCA - Biplot",
)

# Figura convexa por cada periodo climtico
fviz_pca_ind(pca, geom.ind = "point",
             col.ind = datos$Epoca, # Colores por periodo
             palette = c("#00AFBB", "#E7B800", "#FC4E07"),
             addEllipses = TRUE, ellipse.type = "convex",
             legend.title = "Grupos",
             title = "PCA - Plot",
)


# PCA con las observaciones (sitios) y las variables
fviz_pca_biplot(pca, repel = TRUE,
                col.var = "#2E9FDF", # Color de las variables
                col.ind = "#696969", # Color de las observaciones
                title = "PCA - Bilot"
)

# Colores de las observaciones por cada periodo climtico
fviz_pca_biplot(pca,geom="text",co.vat="blue",axes = c(1,2),
                habillage = factor(datos$Epoca),addEllipses = T)+
  labs(x="PC1 (41.7 %)",y="PC2 (32,1 %)")+
  theme_bw()

# Colores de las observaciones por cada periodo climtico 
fviz_pca_biplot(pca, 
                col.ind = datos$Epoca, palette = "jco", 
                addEllipses = TRUE, label = "var",
                col.var = "black", repel = TRUE,
                legend.title = "Epocas")

# Escala de contribuciones de las observaciones y las variables
fviz_pca_biplot(pca, 
                # Observaciones (Sitios)
                geom.ind = "point",
                fill.ind = datos$Epoca, col.ind = "black",
                pointshape = 21, pointsize = 2,
                palette = "jco",
                addEllipses = TRUE,
                # Variables
                alpha.var ="contrib", col.var = "contrib",
                gradient.cols = "RdYlBu",
                legend.title = list(fill = "Epocas", color = "Contrib",
                                    alpha = "Contrib"))



#------------------
# 2) PCA con paquete ggbiplot
pca <- prcomp(amb,scale.=T)

ggbiplot(pca, labels=rownames(datos))

print(ggbiplot(pca, obs.scale = 1, 
               var.scale = 1,labels=rownames(datos), 
               groups = datos$Epoca, 
               ellipse = TRUE, circle = TRUE))+
  theme(legend.direction = 'horizontal', 
        legend.position = 'top')+
  labs(color="Periodos")+
  labs(x="PC1 (41.6 %)",y="PC2 (32,3 %)")+ 
  theme_bw()


print(ggbiplot(pca, obs.scale = 1, 
               var.scale = 1,labels=rownames(datos),
               groups = datos$Epoca, 
               ellipse = TRUE, circle = TRUE)) +
  theme(legend.direction = 'horizontal', 
        legend.position = 'top')+
  labs(color="Periodos")+
  labs(x="PC1 (41.6 %)",y="PC2 (32,3 %)")




#------------------
# 3) pca con vegan
# Realizacin del PCA para extraer las coordenadas ambientales
pca <- rda(tax.hel)
summary(pca)

biplot(pca, choices = c(1, 2),type = "n",scaling =2,
       main="PCA - Scaling 2",cex=2)   # Panel grfico
text(pca, display="sites", cex=0.8, 
     col="blue", lwd=1.5, pos=3)       # Figura de sitios y pocas
ordi=orditorp(pca, display = "species", 
              shrink = FALSE, col = "red", type="n") # Taxones Filtrados
points(pca, display = "sites",            
       cex = 0.6, col = "lightblue", lwd=1.5)  # Opcional - puntos de muestreo
amb1 = envfit(pca,amb)    # Insertar variables ambientales en el pca
plot(amb1,col=4,cex=0.7)




#------------------
# 5) PCA con paquete ggplot2

# Realizacin pca de los paquetes factoextra y ggbiplot 
# Para gererar las coordenadas de los sitios y taxones
pca <- prcomp(tax.hel)

# 1) Coordenadas de los sitios y el factor "coord.sit"
coord.sit <- as.data.frame(pca$x[,1:2])     # Coordenadas de los sitios
coord.sit$sitio <- rownames(coord.sit)      # Crear una columna con nombres de los sitios
coord.sit$grp <-  datos$Epoca               # Adicionar columna de grupos por Epoca
head(coord.sit)                             # vista resumida de las coordenadas de sitios

# 2) Coordenadas de los taxones "coord.tax"
coord.tax <- as.data.frame(pca$rotation[,1:2])    # Dos primeros ejes
coord.tax$especies <- rownames(coord.tax)         # Insertar columna con nombres de las especies
head(coord.tax) 

# 3) Coordenadas de las ambientales "coord.amb"
amb1 = envfit(pca,amb) 
coord.amb = as.data.frame(scores(amb1, "vectors"))
coord.amb$amb <- rownames(coord.amb)         # Insertar columna con nombres de las ambientales
head(coord.amb) 


# 3.1) Figura con vectores de especies
x11()
ggplot() +
  # Sitios
  geom_text_repel(data = coord.sit,aes(PC1,PC2,label=row.names(coord.sit)),
                  size=4)+   # Muestra el cuadro de la figura
  geom_point(data = coord.sit,aes(PC1,PC2,colour=grp),size=4)+
  scale_shape_manual(values = c(21:25))+
  # Taxones  
  geom_segment(data = coord.tax,aes(x = 0, y = 0, xend = PC1, yend = PC2), 
               arrow = arrow(angle=22.5,length = unit(0.25,"cm"),
                             type = "closed"),linetype=1, size=0.6,colour = "red")+
  geom_text_repel(data = coord.tax,aes(PC1,PC2,label=especies),colour = "red")+
  # Factor
  geom_polygon(data=coord.sit,aes(x=PC1,y=PC2,fill=grp,group=grp),alpha=0.30) +
  
  geom_hline(yintercept=0,linetype=3,size=1) + 
  geom_vline(xintercept=0,linetype=3,size=1)+
  guides(shape=guide_legend(title=NULL,color="black"),
         fill=guide_legend(title=NULL))+
  theme_bw()+theme(panel.grid=element_blank())



# 3.2) Figura con vectores de especies (sin flechas)
x11()
ggplot() +
  # Sitios
  geom_text_repel(data = coord.sit,aes(PC1,PC2,label=row.names(coord.sit)),
                  size=4)+   # Muestra el cuadro de la figura
  geom_point(data = coord.sit,aes(PC1,PC2,colour=grp),size=4)+
  scale_shape_manual(values = c(21:25))+
  # Taxones  *valores de cero para caracteres de las flechas (arrow)
  geom_segment(data = coord.tax,aes(x = 0, y = 0, xend = PC1, yend = PC2), 
               arrow = arrow(angle=0,length = unit(0,"cm"),
                             type = "closed"),linetype=0, size=0,colour = "red")+
  geom_text_repel(data = coord.tax,aes(PC1,PC2,label=especies),colour = "red")+
  # Factor
  geom_polygon(data=coord.sit,aes(x=PC1,y=PC2,fill=grp,group=grp),alpha=0.30) +
  
  geom_hline(yintercept=0,linetype=3,size=1) + 
  geom_vline(xintercept=0,linetype=3,size=1)+
  guides(shape=guide_legend(title=NULL,color="black"),
         fill=guide_legend(title=NULL))+
  theme_bw()+theme(panel.grid=element_blank())




# 3.3) Figura con con elipses - geom_mark_ellipse
library(ggsci)
library(ggforce)
# install.packages('Rcpp') # Reinstalar si es necesario
library(Rcpp)

x11()
ggplot() +
  # Sitios
  geom_text_repel(data = coord.sit,aes(PC1,PC2,label=row.names(coord.sit)),
                  size=4)+   # Muestra el cuadro de la figura
  geom_point(data = coord.sit,aes(PC1,PC2,colour=grp),size=4)+
  scale_shape_manual(values = c(21:25))+
  # Taxones  *valores de cero para caracteres de las flechas (arrow)
  geom_segment(data = coord.tax,aes(x = 0, y = 0, xend = PC1, yend = PC2), 
               arrow = arrow(angle=0,length = unit(0,"cm"),
                             type = "closed"),linetype=0, size=0,colour = "red")+
  geom_text_repel(data = coord.tax,aes(PC1,PC2,label=especies),colour = "red")+
  # Factor
  geom_mark_ellipse(data=coord.sit,aes(x=PC1, y=PC2, 
                                       colour=grp,fill=after_scale(alpha(colour, 0.2))), 
                    expand=0, size=0.2) +
  
  geom_hline(yintercept=0,linetype=3,size=1) + 
  geom_vline(xintercept=0,linetype=3,size=1)+
  guides(shape=guide_legend(title=NULL,color="black"),
         fill=guide_legend(title=NULL))+
  theme_bw()+theme(panel.grid=element_blank())



# 3.4) Figura con de elipses por concavidades - geom_mark_hull
library(ggforce)
library(concaveman)
x11()
ggplot() +
  # Sitios
  geom_text_repel(data = coord.sit,aes(PC1,PC2,label=row.names(coord.sit)),
                  size=4)+   # Muestra el cuadro de la figura
  geom_point(data = coord.sit,aes(PC1,PC2,colour=grp),size=4)+
  scale_shape_manual(values = c(21:25))+
  # Taxones  *valores de cero para caracteres de las flechas (arrow)
  geom_segment(data = coord.tax,aes(x = 0, y = 0, xend = PC1, yend = PC2), 
               arrow = arrow(angle=0,length = unit(0,"cm"),
                             type = "closed"),linetype=0, size=0,colour = "red")+
  geom_text_repel(data = coord.tax,aes(PC1,PC2,label=especies),colour = "red")+
  # Factor
  geom_mark_hull(data=coord.sit, aes(x=PC1,y=PC2,fill=grp,group=grp,
                                     colour=grp),alpha=0.30)  +
  
  geom_hline(yintercept=0,linetype=3,size=1) + 
  geom_vline(xintercept=0,linetype=3,size=1)+
  guides(shape=guide_legend(title=NULL,color="black"),
         fill=guide_legend(title=NULL))+
  theme_bw()+theme(panel.grid=element_blank())




# 3.3 Figura con vectores de especies y ambientales
library(ggrepel)

x11()
ggplot() +
  # Sitios
  geom_text_repel(data = coord.sit,aes(PC1,PC2,label=row.names(coord.sit)),
                  size=4)+   # Muestra el cuadro de la figura
  geom_point(data = coord.sit,aes(PC1,PC2,colour=grp),size=4)+
  scale_shape_manual(values = c(21:25))+
  # especies  
  geom_segment(data = coord.tax,aes(x = 0, y = 0, xend = PC1, yend = PC2), 
               arrow = arrow(angle=22.5,length = unit(0.25,"cm"),
                             type = "closed"),linetype=1, size=0.6,colour = "red")+
  geom_text_repel(data = coord.tax,aes(PC1,PC2,label=especies),colour = "red")+
  # Ambiental  
  geom_segment(data = coord.amb,aes(x = 0, y = 0, xend = PC1, yend = PC2), 
               arrow = arrow(angle=22.5,length = unit(0.25,"cm"),
                             type = "closed"),linetype=1, size=0.6,colour = "blue")+
  geom_text_repel(data = coord.amb,aes(PC1,PC2,label=row.names(coord.amb)),colour = "#00abff")+
  # Factor
  geom_polygon(data=coord.sit,aes(x=PC1,y=PC2,fill=grp,group=grp),alpha=0.30) +
  
  geom_hline(yintercept=0,linetype=3,size=1) + 
  geom_vline(xintercept=0,linetype=3,size=1)+
  guides(shape=guide_legend(title=NULL,color="black"),
         fill=guide_legend(title=NULL))+
  theme_bw()+theme(panel.grid=element_blank())